# ADOBE CONFIDENTIAL
#
# Copyright 2010-2022 Adobe
# All Rights Reserved.
#
# NOTICE:  Adobe permits you to use, modify, and distribute this file in
# accordance with the terms of the Adobe license agreement accompanying it.
# If you have received this file from a source other than Adobe,
# then your use, modification, or distribution of it requires the prior
# written permission of Adobe.
#
# Autogenerated by ipa. Don't edit directly, edit the definitions and regenerate it when changing
#

from __future__ import annotations

import ctypes
import base64

from typing import Any, Optional

from enum import Enum
from .sdapiobject import *
from .sdapiobject import *
from .apiexception import APIException

class SDGammaType(Enum):
    """
    Enum representing the gamma predefined values
    """
    """Default gamma"""
    Default = 0
    """Linear gamma"""
    Linear = 1
    """sRGB gamma"""
    SRGB = 2

class bool2(ctypes.Structure):
    _fields_ = [
    ('x', ctypes.c_bool),
    ('y', ctypes.c_bool),
    ]
    def __str__(self):
        return 'x: %r, y: %r' % (self.x, self.y)
    def __getitem__(self, index):
        if index == 0:
            return self.x
        elif index == 1:
            return self.y
        else:
            raise IndexError('Invalid Index')

class bool3(ctypes.Structure):
    _fields_ = [
    ('x', ctypes.c_bool),
    ('y', ctypes.c_bool),
    ('z', ctypes.c_bool),
    ]
    def __str__(self):
        return 'x: %r, y: %r, z: %r' % (self.x, self.y, self.z)
    def __getitem__(self, index):
        if index == 0:
            return self.x
        elif index == 1:
            return self.y
        elif index == 2:
            return self.z
        else:
            raise IndexError('Invalid Index')

class bool4(ctypes.Structure):
    _fields_ = [
    ('x', ctypes.c_bool),
    ('y', ctypes.c_bool),
    ('z', ctypes.c_bool),
    ('w', ctypes.c_bool),
    ]
    def __str__(self):
        return 'x: %r, y: %r, z: %r, w: %r' % (self.x, self.y, self.z, self.w)
    def __getitem__(self, index):
        if index == 0:
            return self.x
        elif index == 1:
            return self.y
        elif index == 2:
            return self.z
        elif index == 3:
            return self.w
        else:
            raise IndexError('Invalid Index')

class int2(ctypes.Structure):
    _fields_ = [
    ('x', ctypes.c_int),
    ('y', ctypes.c_int),
    ]
    def __str__(self):
        return 'x: %d, y: %d' % (self.x, self.y)
    def __getitem__(self, index):
        if index == 0:
            return self.x
        elif index == 1:
            return self.y
        else:
            raise IndexError('Invalid Index')

class int3(ctypes.Structure):
    _fields_ = [
    ('x', ctypes.c_int),
    ('y', ctypes.c_int),
    ('z', ctypes.c_int),
    ]
    def __str__(self):
        return 'x: %d, y: %d, z: %d' % (self.x, self.y, self.z)
    def __getitem__(self, index):
        if index == 0:
            return self.x
        elif index == 1:
            return self.y
        elif index == 2:
            return self.z
        else:
            raise IndexError('Invalid Index')

class int4(ctypes.Structure):
    _fields_ = [
    ('x', ctypes.c_int),
    ('y', ctypes.c_int),
    ('z', ctypes.c_int),
    ('w', ctypes.c_int),
    ]
    def __str__(self):
        return 'x: %d, y: %d, z: %d, w: %d' % (self.x, self.y, self.z, self.w)
    def __getitem__(self, index):
        if index == 0:
            return self.x
        elif index == 1:
            return self.y
        elif index == 2:
            return self.z
        elif index == 3:
            return self.w
        else:
            raise IndexError('Invalid Index')

class float2(ctypes.Structure):
    _fields_ = [
    ('x', ctypes.c_float),
    ('y', ctypes.c_float),
    ]
    def __str__(self):
        return 'x: %f, y: %f' % (self.x, self.y)
    def __getitem__(self, index):
        if index == 0:
            return self.x
        elif index == 1:
            return self.y
        else:
            raise IndexError('Invalid Index')

class float3(ctypes.Structure):
    _fields_ = [
    ('x', ctypes.c_float),
    ('y', ctypes.c_float),
    ('z', ctypes.c_float),
    ]
    def __str__(self):
        return 'x: %f, y: %f, z: %f' % (self.x, self.y, self.z)
    def __getitem__(self, index):
        if index == 0:
            return self.x
        elif index == 1:
            return self.y
        elif index == 2:
            return self.z
        else:
            raise IndexError('Invalid Index')

class float4(ctypes.Structure):
    _fields_ = [
    ('x', ctypes.c_float),
    ('y', ctypes.c_float),
    ('z', ctypes.c_float),
    ('w', ctypes.c_float),
    ]
    def __str__(self):
        return 'x: %f, y: %f, z: %f, w: %f' % (self.x, self.y, self.z, self.w)
    def __getitem__(self, index):
        if index == 0:
            return self.x
        elif index == 1:
            return self.y
        elif index == 2:
            return self.z
        elif index == 3:
            return self.w
        else:
            raise IndexError('Invalid Index')

class double2(ctypes.Structure):
    _fields_ = [
    ('x', ctypes.c_double),
    ('y', ctypes.c_double),
    ]
    def __str__(self):
        return 'x: %f, y: %f' % (self.x, self.y)
    def __getitem__(self, index):
        if index == 0:
            return self.x
        elif index == 1:
            return self.y
        else:
            raise IndexError('Invalid Index')

class double3(ctypes.Structure):
    _fields_ = [
    ('x', ctypes.c_double),
    ('y', ctypes.c_double),
    ('z', ctypes.c_double),
    ]
    def __str__(self):
        return 'x: %f, y: %f, z: %f' % (self.x, self.y, self.z)
    def __getitem__(self, index):
        if index == 0:
            return self.x
        elif index == 1:
            return self.y
        elif index == 2:
            return self.z
        else:
            raise IndexError('Invalid Index')

class double4(ctypes.Structure):
    _fields_ = [
    ('x', ctypes.c_double),
    ('y', ctypes.c_double),
    ('z', ctypes.c_double),
    ('w', ctypes.c_double),
    ]
    def __str__(self):
        return 'x: %f, y: %f, z: %f, w: %f' % (self.x, self.y, self.z, self.w)
    def __getitem__(self, index):
        if index == 0:
            return self.x
        elif index == 1:
            return self.y
        elif index == 2:
            return self.z
        elif index == 3:
            return self.w
        else:
            raise IndexError('Invalid Index')

class ColorRGB(ctypes.Structure):
    _fields_ = [
    ('r', ctypes.c_float),
    ('g', ctypes.c_float),
    ('b', ctypes.c_float),
    ]
    def __str__(self):
        return 'r: %f, g: %f, b: %f' % (self.r, self.g, self.b)
    def __getitem__(self, index):
        if index == 0:
            return self.r
        elif index == 1:
            return self.g
        elif index == 2:
            return self.b
        else:
            raise IndexError('Invalid Index')

class ColorRGBA(ctypes.Structure):
    _fields_ = [
    ('r', ctypes.c_float),
    ('g', ctypes.c_float),
    ('b', ctypes.c_float),
    ('a', ctypes.c_float),
    ]
    def __str__(self):
        return 'r: %f, g: %f, b: %f, a: %f' % (self.r, self.g, self.b, self.a)
    def __getitem__(self, index):
        if index == 0:
            return self.r
        elif index == 1:
            return self.g
        elif index == 2:
            return self.b
        elif index == 3:
            return self.a
        else:
            raise IndexError('Invalid Index')

class SDBaseTypes(SDAPIObject):
    def __init__(self, APIContext, handle, *args, **kwargs):
        """
        Constructor

        :rtype: SDBaseTypes
        """
        super(SDBaseTypes, self).__init__(APIContext, handle, *args, **kwargs)

